/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.demonmobs.model;

import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.model.ModelCustomObj;
import com.lycanitesmobs.demonmobs.DemonMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCacodemon
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelCacodemon() {
        this(1.0f);
    }

    public ModelCacodemon(float shadowSize) {
        this.initModel("cacodemon", DemonMobs.group, "entity/cacodemon");
        this.setPartCenter("head", 0.0f, 1.0f, 0.0f);
        this.setPartCenter("topmouth", 0.0f, 1.0f, 0.0f);
        this.setPartCenter("bottommouth", 0.0f, 1.0f, 0.0f);
        this.lockHeadX = true;
        this.lockHeadY = true;
        this.trophyScale = 0.5f;
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("head")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
        } else {
            this.centerPartToPart(partName, "head");
            this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            this.uncenterPartToPart(partName, "head");
        }
        if (partName.equals("topmouth")) {
            this.rotate(-5.0f, rotY, rotZ);
        }
        if (partName.equals("bottommouth")) {
            this.rotate(5.0f, rotY, rotZ);
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked() || entity instanceof EntityCreatureAgeable && ((EntityCreatureAgeable)entity).isInLove()) {
            if (partName.equals("topmouth")) {
                this.rotate(-25.0f, rotY, rotZ);
            }
            if (partName.equals("bottommouth")) {
                this.rotate(25.0f, rotY, rotZ);
            }
            this.rotate(12.5f, rotY, rotZ);
        }
        if (entity instanceof EntityCreatureTameable && ((EntityCreatureTameable)entity).isSitting()) {
            if (partName.equals("topmouth")) {
                this.rotate(5.0f, rotY, rotZ);
            }
            if (partName.equals("bottommouth")) {
                this.rotate(-5.0f, rotY, rotZ);
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

